/*
 * Recognizer.java
 *
 * Created on February 9, 2004, 1:43 PM
 */

import java.io.*;

import java.util.Vector;

import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.AudioFileFormat;

/**
 *
 * @author  jonbrown
 */
public class Recognizer {
    
    private String command = "/home/jonbrown/sphinx2/bin/sphinx2-current";
    
    private Recorder recorder;
    private TargetDataLine targetDataLine;
    private AudioFileFormat.Type targetType;
    private AudioFormat audioFormat;
    private File audioFile;
    private File hypFile;
    
    /** Creates a new instance of Recognizer */
    public Recognizer(File audiofile, File hypfile) {
        audioFile = audiofile;
        hypFile = hypfile;
    }
    
    public void startRecording() {
        targetType = AudioFileFormat.Type.WAVE;
        audioFormat =  new AudioFormat(16000.0F, 16, 1, true, false);        
        
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        try
        {
            targetDataLine = (TargetDataLine) AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            System.out.println("Can't get a recording line.");
            System.exit(1);
        }  
        recorder = new Recorder(targetDataLine, targetType, audioFile);
        recorder.start();
    }
    
    public void stopRecording() {
        recorder.stopRecording();
    }
    
    public void doRecognize() {
        try {
            System.out.println("Starting recognizer: " + command);
            Process p = Runtime.getRuntime().exec(command);
                       
            int ret = 0;
            ret = p.waitFor();
            if (ret != 0) {
               System.out.println("Sphinx has produced an error.  Failing..."); 
               System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Uh oh: " + e.toString());
            System.exit(1);
        }
    }
    
    public String getBest() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(hypFile)); 
            String s = br.readLine();
            s = s.substring(4, s.length()-1);
            br.close();
            return s;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        
        return null;
    }
    
    public String[] getNBest() {
        Vector v = new Vector();
        try {
            BufferedReader br = new BufferedReader(new FileReader(hypFile));             
            String s = "";
            while ( (s = br.readLine()) != null ) {
                s = s.substring(4, s.length()-1);
                v.addElement(s);
            }
            
            String[] ret = new String[3];
            for (int i=0; i<v.size(); i++) {
                ret[i] = (String) v.elementAt(i);
            }
            br.close();
            return ret;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        
        return null;
    }
    
    public String getBestMatch(String[] s, Vector choices) {   
        if (s == null) {
            //microphone problem
            return "NotHeard";
        }
        else {
            for (int i=0; i<s.length; i++) {
                String cur = s[i];            
                for (int j=0; j<choices.size(); j++) {
                    String choice = (String) choices.elementAt(j);
                    String choicenopun = choice;
                    if (choice.charAt(choice.length()-1) == '.') {
                        choicenopun = choice.substring(0, choice.length()-1);
                    }
                    if (cur.equalsIgnoreCase(choicenopun)){
                        return choice;
                    }
                }
            }
        }
        
        //if we get here, we didn't find a match
        return "NotUnderstood";
    }
    
}
