package plot;

import java.awt.*;

import org.jfree.chart.*;
import org.jfree.chart.plot.*;
import org.jfree.data.xy.*;


public class ChartPlot {
	public static void plot(double[][] plot, String[] names, String title, String xaxis, String yaxis) {
	  XYSeries[] series = new XYSeries[plot[0].length]; 
	  for(int i = 0; i < plot[0].length; i++) series[i] = new XYSeries(names[i]);
	  for(int i = 0; i < plot.length; i++){
	    for(int s = 0; s < plot[i].length; s++)
	      series[s].add(i/60.0, plot[i][s]);
	  }
	  
	  XYSeriesCollection col = new XYSeriesCollection();
	  for(int s = 0; s < plot[0].length; s++)
	    col.addSeries(series[s]);
	  
	  
	  JFreeChart chart = ChartFactory.createXYLineChart(title, xaxis, yaxis, col, PlotOrientation.VERTICAL, true, false, false);
	  ChartFrame frame = new ChartFrame(title, chart);
	  frame.setBackground(Color.WHITE);
	  frame.setForeground(Color.WHITE);
	  frame.setVisible(true);
	  frame.setSize(800,600);
	}
	
	public static void xyplot(double[][] plot, double[] time, String[] names, String title, String xaxis, String yaxis) {
    XYSeries[] series = new XYSeries[plot[0].length]; 
    for(int i = 0; i < plot[0].length; i++)
      series[i] = new XYSeries(names[i]);
    for(int i = 0; i < plot.length; i++){
      for(int s = 0; s < plot[i].length; s++)
        series[s].add(time[i], plot[i][s]);
    }
    
    XYSeriesCollection col = new XYSeriesCollection();
    for(int s = 0; s < plot[0].length; s++)
      col.addSeries(series[s]);
    
    
    JFreeChart chart = ChartFactory.createXYLineChart(title, xaxis, yaxis, col, PlotOrientation.VERTICAL, true, false, false);
    ChartFrame frame = new ChartFrame(title, chart);
    frame.setSize(1280,800);
    frame.setVisible(true);
    
  }
}
