package modelchecking;

import formulae.*;
import automata.*;
import umontreal.iro.lecuyer.probdist.BetaDist;

public class Statistical {
  
  public static EstimationResult IntervalEstimation(IFormula f, HybridAutomaton h, double alpha, double beta, double delta, double coefficient){
    EstimationResult r = new EstimationResult();
    
    double bound = f.samplingBound();
    System.out.println("Sampling with bound " + bound);
    
    int nTraces = 0;
    int nSatisfied = 0;
    double postProb = 0;
    do { 
      Trace t = h.run(bound);
     
      nTraces++;
      if(f.satisfied(t))//{
        nSatisfied++;
        //System.out.print("+");
      //} else
      //  System.out.print("-");
      //System.out.flush();
      
      r.p = (nSatisfied + alpha)/(nTraces + alpha + beta);
      r.t0 = r.p - delta;
      r.t1 = r.p + delta;
      
      if (r.t1 > 1){
        r.t0 = 1 - 2*delta;
        r.t1 = 1;
      } else if (r.t0 < 0) {
        r.t0 = 0;
        r.t1 = 2*delta;
      }
      
      BetaDist bd = new BetaDist(nSatisfied + alpha, nTraces -nSatisfied + beta);
      
      postProb = bd.cdf(r.t1) - bd.cdf(r.t0);
      
    } while(postProb < r.p);
    r.n = nTraces;
    r.nSat = nSatisfied;
    System.out.println();
    return r;
  }
}