package formulae;

import java.util.*;

import automata.*;

public class TVar implements ITerm {
  private String elemName;
  private int varNum;
  
  public TVar(String elemName, int varNum){
    this.elemName = elemName;
    this.varNum = varNum;
  }
  
  public double interpret(TraceItem s, Map<String, Element> sigma) {
    if (!sigma.containsKey(elemName))
      System.err.println("[Warning] Accessing non-existing element name. Open formula?");
    
    return sigma.get(elemName).getState().getVar(varNum);
  }

  @Override
  public boolean closed(Set<String> names) {
    return names.contains(elemName);
  }
}
