package formulae;

import java.util.*;

import automata.*;

public class TMult implements ITerm {
  private ITerm t1, t2;
  
  public TMult(ITerm t1, ITerm t2) { this.t1 = t1; this.t2 = t2; }

  public double interpret(TraceItem s, Map<String, Element> sigma) {
    double t1res = t1.interpret(s, sigma);
    if(t1res == 0) return 0;
    return t1res * t2.interpret(s, sigma);
  }

  public boolean closed(Set<String> names) { return true; }
}
