package formulae;

import java.util.Map;
import java.util.Set;

import automata.Element;
import automata.Trace;

public abstract class Predicate extends Formula {
  protected ITerm t1;
  protected ITerm t2;

  public Predicate(ITerm t1, ITerm t2) {
    this.t1 = t1;
    this.t2 = t2;
  }
  
  public boolean closed(Set<String> names) {
    return t1.closed(names) && t2.closed(names);
  }
  
  public abstract boolean satisfied(Trace s, Map<String, Element> sigma);
  
  public double samplingBound(){ return 0; }
}
