package formulae;

import java.util.Map;

import automata.Element;
import automata.Trace;

public class PGT extends Predicate {
  private double indiff;
  
  public PGT(ITerm t1, ITerm t2) {
    this(t1, t2, IFormula.INDIFFERENCE_VALUE);
  }

  public PGT(ITerm t1, ITerm t2, double indiff) {
    super(t1, t2);
    this.indiff = indiff;
  }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return t1.interpret(s.getState(), sigma) > t2.interpret(s.getState(), sigma) && new PNEQ(t1, t2, indiff).satisfied(s, sigma);
  }
}
