package formulae;

import java.util.Map;
import java.util.Set;

import automata.Element;
import automata.Trace;

public class PEQ extends Predicate {
  private double indiff;
  
  public PEQ(ITerm t1, ITerm t2) {
    this(t1, t2, IFormula.INDIFFERENCE_VALUE);
  }

  public PEQ(ITerm t1, ITerm t2, double indiff) {
    super(t1, t2);
    this.indiff = indiff;
  }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return Math.abs(t1.interpret(s.getState(), sigma) - t2.interpret(s.getState(), sigma)) < indiff;
  }

  public boolean closed(Trace s, Set<String> names) {
    return t1.closed(names) && t2.closed(names);
  }
}
