package formulae;

import java.util.*;

import automata.*;

public class FUntil extends Formula {
  private Formula alpha;
  private Formula beta;
  private double bound;
  
  public FUntil(Formula alpha, Formula beta, double bound){ 
    this.alpha = alpha; this.beta = beta; this.bound = bound;
  }
  
  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    if(!alpha.satisfied(new Trace(s), sigma))
      return false;
    
    double t = s.timeBetween(0, 1); // Next step
    Trace tr = new Trace(s);
    tr.step();
    while(t < bound && !tr.lastState()){
      if(beta.satisfied(new Trace(tr), sigma)) {
        beta.satisfied(new Trace(tr), sigma);
        return true;
      }
      if(!alpha.satisfied(new Trace(tr), sigma)) return false;
      
      t += tr.timeBetween(0, 1);
      tr.step();
    }
    
    return beta.satisfied(tr, sigma);
  }
  
  public boolean closed(Set<String> names) {
    return alpha.closed(names) && beta.closed(names);
  }
  
  public double samplingBound(){ return bound + Math.max(alpha.samplingBound(), beta.samplingBound()); }

}
