package formulae;

import java.util.*;

import automata.*;

public class FEventually extends Formula {
  private Formula f;
  
  public FEventually(Formula alpha, double bound){ 
    this.f = new FUntil(new FTrue(), alpha, bound);
  }
  
  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return f.satisfied(s, sigma);
  }
  
  public boolean closed(Set<String> names) {
    return f.closed();
  }
  
  public double samplingBound(){ return f.samplingBound(); }

}
