package formulae;

import java.util.*;

import automata.*;

public class FAlways extends Formula {
  private Formula f;
  
  public FAlways(Formula alpha, double bound){ 
    this.f = new FNeg(new FEventually(new FNeg(alpha), bound));
  }
  
  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return f.satisfied(s, sigma);
  }
  
  public boolean closed(Set<String> names) {
    return f.closed();
  }
  
  public double samplingBound(){ return f.samplingBound(); }

}
