package automata.functions;

import automata.*;

public class PositiveGaussianDistribution extends GaussianDistribution {

  public PositiveGaussianDistribution(double mean, double stddev) { super(mean, stddev); }

  public double draw(State s) {
    double result = RandGen.gaussian(mean, stddev);
    if(result < 0) return 0;
    return result;
  }
}
