package automata;

import java.util.*;

public class Trace {
  private List<TraceItem> trace;
  private int traceStart;
  private double time;
  
  public Trace(){
    trace = new ArrayList<TraceItem>();
    traceStart = 0;
    time = 0;
  }
  
  // Shallow copy constructor
  public Trace(Trace other){
    this.trace = other.trace;
    this.traceStart = other.traceStart;
    this.time = other.time;
  }
  
  public void append(TraceItem ti) { trace.add(ti); time = time + ti.t; }
  
  public double step(){
    double stepTime = timeBetween(0, 1);
    time = time - stepTime;
    traceStart++;
    return stepTime;
  }
  
  public boolean lastState(){
    return traceStart == trace.size() - 1;
  }
  
  // k0 <= t < k1
  public double timeBetween(int k0, int k1) {
    double t = 0;
    for(int i = k0; i < k1; i++)
      t += trace.get(traceStart + i).t;
    return t;
  }
  
  public double totalTime() { return time; }
  
  public TraceItem getState() { return trace.get(traceStart); }
  
  public int size() { return trace.size() - traceStart; }
  
  public String toString(){
    String result = "*** TRACE START ***\n";
    for(TraceItem ti : trace)
      result = result + ti + "\n";
    return result + "**** TRACE END ****\n";
  }
}
