package automata;

import java.util.*;

public class StateSet {
  public Set<State> completed;
  public Set<State> current;
  
  public StateSet(){
    completed = new HashSet<State>();
    current = new HashSet<State>();
  }
  
  public StateSet(StateSet other){
    completed = new HashSet<State>();
    current = new HashSet<State>();
    
    completed.addAll(other.completed); // Shallow copy.
    for(State s : other.current) current.add(new State(s)); // Deep copy.
  }
  
  public void union(StateSet other){
    completed.addAll(other.completed);
    current.addAll(other.current);
  }
  
  public String toString(){
    String r = "*** START STATESET ***\n";
    for(State s: completed)
      r += s + "\n";
    for(State s: current)
      r += s + "\n";
    r +=       "**** END STATESET ****";
    return r;
  }
}
