package automata;

public class State {
	private double[] s;
	
	public State(double[] s){ this.s = s; }
	public State(int numVars){ s = new double[numVars]; }
	
	// Deep copy constructor
	public State(State other){
		s = new double[other.s.length];
		for(int i = 0; i < s.length; i++)
			s[i] = other.s[i];
	}
	
	public double[] getState() { return s; }
  public void setState(double[] s) { this.s = s; }
  public int getNumVars() { return s.length; } 
  public double getVar(int var){ return s[var]; }
  public void setVar(int var, double val) { s[var] = val; } 
	
	public String toString() {
	  String result = "[";
	  for(int i = 0; i < s.length - 1; i++) result += ((int)(s[i] * 100))/100f + ", ";
	  result += ((int)(s[s.length-1] * 100))/100f + "]";
	  return result;
	}
}
