package automata;

import java.util.*;

public class RandGen {
  private static Random rand;
  
  public static void initialise(){ rand = new Random(System.currentTimeMillis()); }
  public static void initialise(long seed){ rand = new Random(seed); }
  
  public static double uniform() { return rand.nextDouble(); }
  public static double uniform(double a, double b) { return a + (b - a)*rand.nextDouble(); }
  
  public static double gaussian() { return rand.nextGaussian(); }
  public static double gaussian(double mean, double stddev) { return mean + stddev*rand.nextGaussian(); }
  
  public static double exponential(double lambda) {
    return ( ( -1 * Math.log(1-rand.nextDouble()) ) / lambda );
  }
}
