package automata;

import java.util.*;

public class MessageLayer {
  private Map<String, Queue<Message>> queues;
  
  public MessageLayer(){
    queues = new HashMap<String, Queue<Message>>();
  }
  
  private Queue<Message> getQueue(String channel){
    Queue<Message> chanQ = queues.get(channel);
    if(chanQ == null){
      chanQ = new PriorityQueue<Message>();
      queues.put(channel, chanQ);
    }
    
    return chanQ;
  }
  
  public void insertMessage(String channel, Message m){
    getQueue(channel).add(m);
  }
  
  public Message receiveMessage(String channel){
    Queue<Message> chanQ = getQueue(channel);
    
    if(chanQ.isEmpty()){
      System.out.println("[WARNING] Returning null message for channel \""+ channel +"\".");
      return null;
    }
    
    return chanQ.poll();
  }
  
  public boolean hasMessage(String channel){
    return !getQueue(channel).isEmpty();
  }
}
