package automata;
import flanagan.integration.*;
import automata.functions.*;


public class Location {
  private static int ID_COUNTER = 0;
  
  private Edge[] edges;
  private IContinuousDistribution cd;
  private ITransitionDistribution td;
  private DerivnFunction evol;
  private double odeStep;
  // TODO: private IFormula chi;
  
  private int ID;
  
  public Location(IContinuousDistribution cd, ITransitionDistribution td, DerivnFunction evol, double odeStep){
    this.cd = cd; this.td = td; this.evol = evol; this.odeStep = odeStep; this.ID = ID_COUNTER++;
  }
  
  /**
   * Set the edges whose source is this location.
   * @param edges The array of outgoing edges.
   */
  public void setEdges(Edge[] edges) { this.edges = edges; }
  
  /**
   * Get an edge given an edge index.
   * @param edge The edge index.
   * @return The edge.
   */
  public Edge getEdge(int edge) { return edges[edge]; }
  
  /**
   * Given the current state of an element, decide whether to do an edge jump or
   * or do a continuous transition.
   * @param s The state of the element.
   * @return -1 for a continuous transition, >= 0 for the edge number.
   */
  public int transition(State s, MessageLayer ml){ return td.draw(s, ml); }
  
  /**
   * Given an edge index and an element's state, perform the jump through the
   * corresponding edge.
   * @param edge The edge to jump through.
   * @param s The state of the element.
   * @return The new state of the element after performing the jump.
   */
  public State transition(int edge, State s) { return edges[edge].transition(s); }
  
  /**
   * Have the location decide how much time to spend at the current location,
   * evolving continuously during that time.
   * @param s The state of the element.
   * @return How much time to spend at this location.
   */
  public double cTransition(State s) { return cd.draw(s); }
  
  /**
   * Given some time t and some state, perform the continuous evolution of the
   * state for t time and return the new state.
   * @param t How much time to spend evolving continuously.
   * @param s The state of the element.
   * @return
   */
  public State cTransition(double t, State s) {
    if(evol == null)
      return s; //TODO: check whether we need to deep-copy state
    State sn = new State(s);
    sn.setState(RungeKutta.fourthOrder(evol, 0, sn.getState(), t, odeStep));
    
    return sn;
  }
  
  public String toString() { return "L["+ID+"]"; }
}
