package automata;
import automata.functions.*;
import automata.actions.*;

public class Edge {
  private static int ID_COUNTER = 0;
  private Location src;
  private Location dst;
  private IAction a;
  
  private IJumpFunction f;
  
  private int ID;
  
  public Edge(Location src, Location dst, IJumpFunction f){
    this.src = src;
    this.dst = dst;
    this.f = f;
    this.a = null;
    this.ID = ID_COUNTER++;
  }
  
  public Edge(Location src, Location dst, IJumpFunction f, IAction a){
    this(src, dst, f);
    this.a = a;
  }
  
  public Edge(Location src, Location dst, ReceiveAction a){
    this(src, dst, null, a);
  }
  
  public State transition(State s){ return f.transition(s); }
  
  public boolean hasAction() { return a != null; }
  
  public IAction getAction(){ return a; }

  public Location getSrc() { return src; }
  public Location getDst() { return dst; }
  
  public String toString() { return "Ed["+ID+"]{"+ src + "->" + dst + ";" + a + "}"; }
}
