package automata;

import java.util.*;

public class AutomatonState {
  private Set<Element> elements;
  
  public AutomatonState(){
    elements = new HashSet<Element>();
  }
  
  // Deep copy constructor
  public AutomatonState(AutomatonState other){
    this();
    for(Element e : other.elements)
      elements.add(new Element(e));
  }
  
  // Deep copy of incoming elements
  public void addElement(Element e) { elements.add(new Element(e)); }
  public void removeElement(Element e) { elements.remove(e); }
  public void setElements(Set<Element> elements) {
    for(Element e: elements) this.elements.add(new Element(e));
  }
  public Set<Element> getElements() { return elements; }
  
  public String toString() { return elements.toString(); }
}
