package formulae;

import java.util.*;

import automata.*;

public class TSub implements ITerm {
  private ITerm t1, t2;
  
  public TSub(ITerm t1, ITerm t2) { this.t1 = t1; this.t2 = t2; }

  public double interpret(TraceItem s, Map<String, Element> sigma) {
    return t1.interpret(s, sigma) - t2.interpret(s, sigma);
  }

  public boolean closed(Set<String> names) { return true; }
}
