package formulae;

import java.util.*;

import automata.*;

public abstract class TAgg implements ITerm {
  private String elemName;
  private ITerm t;
  
  public TAgg(String elemName, ITerm t){
    this.elemName = elemName;
    this.t = t;
  }
  
  public double interpret(TraceItem s, Map<String, Element> sigma) {
    Map<String, Element> newSigma = new HashMap<String, Element>(sigma);
    Set<Element> elems = s.as.getElements();
    
    if(elems.size() == 0){
      System.out.println("[WARNING] Aggregating over 0 elements. Returning 0.");
      return 0;
    } else if(elems.size() == 1){
      newSigma.put(elemName, elems.iterator().next());
      return t.interpret(s, newSigma);
    } else {
      Iterator<Element> i = elems.iterator();
      newSigma.put(elemName, i.next());
      double result = t.interpret(s, newSigma);
      while(i.hasNext()) {
        Element e = i.next();
        newSigma.put(elemName, e);
        result = op(result, t.interpret(s, newSigma));
      }
      return result;
    }
  }

  abstract double op(double a1, double a2);
  
  public boolean closed(Set<String> names) {
    Set<String> newNames = new HashSet<String>(names);
    newNames.add(elemName);
    return t.closed(newNames);
  }
}
