package formulae;

import java.util.Map;

import automata.*;

public class PLEQ extends Predicate {
  private double indiff;
  
  public PLEQ(ITerm t1, ITerm t2) {
    this(t1, t2, IFormula.INDIFFERENCE_VALUE);
  }

  public PLEQ(ITerm t1, ITerm t2, double indiff) {
    super(t1, t2);
    this.indiff = indiff;
  }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return !new PGT(t1,t2,indiff).satisfied(s, sigma);
  }
}
