package formulae;

import java.util.*;

import automata.*;

public abstract class Formula implements IFormula {

  @Override
  public boolean satisfied(Trace s) {
    return satisfied(s, new HashMap<String, Element>());
  }

  @Override
  public boolean closed() {
    return closed(new HashSet<String>());
  }

  protected abstract boolean satisfied(Trace s, Map<String, Element> sigma);

  protected abstract boolean closed(Set<String> names);
}
