package formulae;

import java.util.*;

import automata.*;

public class FUnivQ extends Formula {
  private String name;
  private Formula alpha;
  
  public FUnivQ(String name, Formula alpha){ this.name = name; this.alpha = alpha; }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    // If we assume the miracle of alpha-conversion, we can simply pop "name" from the
    // map at the end of this method and not copy everything everytime.
    Map<String, Element> newSigma = new HashMap<String, Element>(sigma.size() + 1);
    newSigma.putAll(sigma);
    
    for(Element e : s.getState().as.getElements()){
      newSigma.put(name, e);
      if(!alpha.satisfied(s, newSigma))
        return false;
    }
    
    return true;
  }


  public boolean closed(Set<String> names) {
    Set<String> newNames = new HashSet<String>(names);
    newNames.add(name);
    return alpha.closed(newNames);
  }
  
  public double samplingBound(){ return alpha.samplingBound(); }
}