package formulae;
import java.util.Map;
import java.util.Set;

import automata.Element;
import automata.Trace;

public class FNeg extends Formula {
  private Formula alpha;
  
  public FNeg(Formula alpha) {
    this.alpha = alpha;
  }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return !alpha.satisfied(s, sigma);
  }

  public boolean closed(Set<String> names) {
    return alpha.closed(names);
  }
  
  public double samplingBound(){ return alpha.samplingBound(); }
}