package formulae;

import java.util.Map;
import java.util.Set;

import automata.Element;
import automata.Trace;

public class FAnd extends Formula {
  private Formula alpha;
  private Formula beta;
  
  public FAnd(Formula alpha, Formula beta) {
    this.alpha = alpha;
    this.beta = beta;
  }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return alpha.satisfied(s, sigma) && beta.satisfied(s, sigma);
  }

  public boolean closed(Set<String> names) {
    return alpha.closed(names) && beta.closed(names);
  }
  
  public double samplingBound(){ return Math.max(alpha.samplingBound(), beta.samplingBound()); }
}
