package formulae;
import java.util.Map;
import java.util.Set;

import automata.Element;
import automata.Trace;

public class FAlive extends Formula {
  private String elemName;
  
  public FAlive(String elemName) {
    this.elemName = elemName;
  }

  public boolean satisfied(Trace s, Map<String, Element> sigma) {
    return s.getState().as.getElements().contains(sigma.get(elemName));
  }

  public boolean closed(Set<String> names) {
    return names.contains(elemName);
  }
  
  public double samplingBound(){ return 0; }
}