package automata;

import java.util.*;

public class HybridAutomaton {
  private List<Location> locations;
  private Set<Element> startingElements;
  
  public HybridAutomaton(){
    locations = new ArrayList<Location>();
    startingElements = new HashSet<Element>();
  }
  
  // Set up automaton
  public int addLocation(Location l){ locations.add(l); return locations.size() - 1; }
  public void addStartingElement(Element e){ startingElements.add(e); }
  
  public Trace run(double bound) {
    MessageLayer ml = new MessageLayer();
    AutomatonState s = new AutomatonState();
    s.setElements(startingElements);

    Trace trace = new Trace();

    double runtime = 0;
    double cTime = 0;
    // Collection of elements that will be doing a transition.
    List<Element> transitioning = new LinkedList<Element>();
    while (runtime <= bound) { // Until we get a "complete" finite trace
      //System.out.println(runtime);
      trace.append(new TraceItem(new AutomatonState(s), cTime, runtime));

      cTime = Double.MAX_VALUE;
      for(Element e : s.getElements()){
        cTime = Math.min(cTime, e.getNextTransition());
        if (e.getNextTransition() <= 0)
          transitioning.add(e);
      }

      // if(cTime == 0) // Unnecessary
      for (Element e : transitioning) {
        Element newElement = e.transition(runtime, ml);
        if (newElement == null)
          s.removeElement(e); // Die action
        else if (!e.equals(newElement))
          s.addElement(newElement); // New action
        // else, null action, everything as usual
      }

      if (cTime > 0) {
        runtime = runtime + cTime;
        for(Element e : s.getElements())
          e.transition(cTime);
      }

      transitioning.clear();
    }

    return trace;
  }
}
