#!/bin/bash

files=("wlan5" "wlan6")


thetas=("0.1" "0.15" "0.2" "0.25" "0.5")

ntests="10"
nruns="10"

for f in "${files[@]}"
do
  echo $f
  i="0"
  while [ $i -lt $ntests ]
  do
    for theta in "${thetas[@]}"
    do
      echo $theta
      j="0"
      while [ $j -lt $nruns ]
      do
        ./rungc.sh $f.nm $f.fm 20 2000 30 -MACHINE -PROFILE -theta=$theta -BayesLearning -maxtraces=40000 >> wlan_tests/$f\_HT_$theta\_test$i.txt
        j=$(( $j+1 ))
        echo -n +
      done
      echo \ Finished theta $theta
    done
    i=$(( $i+1 ))
  done
done

echo
