#!/bin/bash


thetas=("0.9" "0.95" "0.99")

ntests="5"
nruns="10"

i="0"
while [ $i -lt $ntests ]
do
  for theta in "${thetas[@]}"
  do
    j="0"
    while [ $j -lt $nruns ]
    do
      ./rungc.sh uberttinymodel.nm tinyrobot.fm 20 3000 150 -MACHINE -PROFILE -theta=$theta -H=0.3 -lastnsat=1000 -pathnsat=0 -lastsat=10000 -pathsat=10000 -reward=lastaction -update=compcount -checkpoint >> robot_results/tiny_HT_$theta\_results.txt
      echo run $j
      j=$(( $j+1 ))
    done
    echo $theta
  done
  i=$(( $i+1 ))
  echo test $i
done
