import os
import sys

NULL_HYPOTHESIS_INDEX = 0
RUNTIME_INDEX = 12

thetas1=("0.8", "0.85", "0.9")
thetas2=("0.9", "0.95", "0.99")
thetas3=("0.9", "0.95", "0.99")
thetas=(thetas1, thetas2, thetas3)

files=("robot", "average", "tiny")

class InstanceResults:
    def __init__(self):
        self.runtimes = []
        self.alternateHypothesis = []

    def avgRuntime(self):
        total = 0.0
        for runtime in self.runtimes:
            total = total + runtime
        return total / len(self.runtimes)

    def foundAlt(self):
        for alt in self.alternateHypothesis:
            if(alt):
                return True
        return False
    
    def foundNull(self):
        for alt in self.alternateHypothesis:
            if(not alt):
                return True
        return False

    def toString(self):
        result = str(self.avgRuntime()) + ", "
        PMC = "T"
        if(self.foundNull() and self.foundAlt()):
            PMC = "F*"
        elif(self.foundNull() and (not self.foundAlt())):
            PMC = "T"
        elif((not self.foundNull()) and self.foundAlt()):
            PMC = "F"
        result = result + PMC
        return result
        
def parseOneTest(fi, r):
    runtime = 0
    foundAlternate = False;
    for lineNum in range(10):
        line = fi.readline()
        if(foundAlternate):
            continue
        tokens = line.rstrip("\n\r").split(",")
        runtime = runtime + float(tokens[RUNTIME_INDEX])
        if(tokens[NULL_HYPOTHESIS_INDEX] == "0"):
            foundAlternate = True
    r.runtimes.append(runtime)
    r.alternateHypothesis.append(foundAlternate)
            
    

def parseOne(f, thetas):
    print f
    for theta in thetas:
        filename = f + "_HT_" + theta + "_results.txt"
        fi = open(filename, "r")
        r = InstanceResults()
        for t in range(5):
            parseOneTest(fi, r)
        print theta + ", " + r.toString()
        fi.close()
    

def main():
    for f in range(len(files)):
        parseOne(files[f], thetas[f])

if __name__ == "__main__":
    main()
