#!/bin/bash


thetas=("0.97" "0.99")


ntests="5"
nruns="10"

echo "MEDIUMSMALL 0.95"

i="0"
while [ $i -lt $nruns ]
do
  ./rungc.sh mediumsmall.nm mediumrobot.fm 20 5000 500 -MACHINE -PROFILE -theta=0.95 -H=0.3 -lastnsat=1000 -pathnsat=0 -lastsat=10000 -pathsat=10000 -reward=lastaction -update=compcount -checkpoint >> robot_results/mediumsmall_final_0.95_results.txt
  i=$(( $i+1 ))
  echo run $i
done


nlim="50"

echo "MEDIUMSMALL 0.97/0.99"

i="0"
while [ $i -lt $nlim ]
do
  for theta in "${thetas[@]}"
  do
    ./rungc.sh mediumsmall.nm mediumrobot.fm 20 5000 500 -MACHINE -PROFILE -theta=$theta -H=0.3 -lastnsat=1000 -pathnsat=0 -lastsat=10000 -pathsat=10000 -reward=lastaction -update=compcount -checkpoint >> robot_results/mediumsmall_final_$theta\_results.txt
    echo $theta
  done
  i=$(( $i+1 ))
  echo test $i
done


echo "AVERAGEMODEL"

avglim="20"
avgthetas=("0.9" "0.95")

i="0"
while [ $i -lt $avglim ]
do
  for theta in "${avgthetas[@]}"
  do
    ./rungc.sh averagemodel.nm tinyrobot.fm 20 3500 200 -MACHINE -PROFILE -theta=$theta -H=0.3 -lastnsat=1000 -pathnsat=0 -lastsat=10000 -pathsat=10000 -reward=lastaction -update=compcount -checkpoint >> robot_results/average_final_$theta\_results.txt
    echo $theta
  done
  i=$(( $i+1 ))
  echo test $i
done

echo "INTERVAL ESTIMATION"

sempre="1000"

i="0"
while [ $i -lt $sempre ]
do
  ./rungc.sh robot3.nm robot2.fm 20 2000 350 -DEBUG -IntervalEstimation -H=0.3 -lastnsat=1000 -pathnsat=0 -lastsat=10000 -pathsat=10000 -reward=lastaction -update=compcount -checkpoint >> robot_results/biiigrobot_IE_results.txt
  i=$(( $i+1 ))
  echo test $i
done
