import os
import sys

NULL_HYPOTHESIS_INDEX = 0
RUNTIME_INDEX = 12

thetas34=("0.5", "0.8", "0.85", "0.9", "0.95")
thetas36=("0.3", "0.4", "0.45", "0.5", "0.8")
thetas44=("0.5", "0.7", "0.8", "0.9", "0.95")
thetas46=("0.5", "0.7", "0.8", "0.9", "0.95")
thetasAll=(thetas34, thetas36, thetas44, thetas46)

files=("csma3_4", "csma3_6", "csma4_4", "csma4_6")

class InstanceResults:
    def __init__(self):
        self.runtimes = []
        self.alternateHypothesis = []

    def avgRuntime(self):
        total = 0.0
        for runtime in self.runtimes:
            total = total + runtime
        return total / len(self.runtimes)

    def foundAlt(self):
        for alt in self.alternateHypothesis:
            if(alt):
                return True
        return False
    
    def foundNull(self):
        for alt in self.alternateHypothesis:
            if(not alt):
                return True
        return False

    def toString(self):
        result = str(self.avgRuntime()) + ", "
        PMC = "T"
        if(self.foundNull() and self.foundAlt()):
            PMC = "F*"
        elif(self.foundNull() and (not self.foundAlt())):
            PMC = "T"
        elif((not self.foundNull()) and self.foundAlt()):
            PMC = "F"
        result = result + PMC
        return result
        
def parseOneTest(fi, r):
    runtime = 0
    foundAlternate = False;
    for line in fi:
        tokens = line.rstrip("\n\r").split(",")
        runtime = runtime + float(tokens[RUNTIME_INDEX])
        if(tokens[NULL_HYPOTHESIS_INDEX] == "0"):
            foundAlternate = True
            break
    r.runtimes.append(runtime)
    r.alternateHypothesis.append(foundAlternate)
            
    

def parseOne(thetas, f):
    print f
    for j in range(len(thetas)):
        r = InstanceResults()
        for i in range(10):
            filename = f + "_HT_" + thetas[j] + "_test"+str(i)+".txt"
            fi = open(filename, "r")
            parseOneTest(fi, r)
            fi.close()
        print thetas[j] + ", " + r.toString()
    

def main():
    for i in range(4):
        parseOne(thetasAll[i], files[i])

if __name__ == "__main__":
    main()
