#!/bin/bash

files=("csma3_4" "csma3_6" "csma4_4" "csma4_6")


thetas34=("0.5" "0.8" "0.85" "0.9" "0.95")
thetas36=("0.3" "0.4" "0.45" "0.5" "0.8")
thetas44=("0.5" "0.7" "0.8" "0.9" "0.95")
thetas46=("0.5" "0.7" "0.8" "0.9" "0.95")

ntests="10"
nruns="10"

f="csma3_4"
echo $f
i="5"
while [ $i -lt $ntests ]
do
  for theta in "${thetas34[@]}"
  do
    echo $theta
    j="0"
    while [ $j -lt $nruns ]
    do
      ./rungc.sh $f.nm $f.fm 20 2000 30 -MACHINE -PROFILE -theta=$theta -BayesLearning -maxtraces=40000 >> csma_tests/$f\_HT_$theta\_test$i.txt
      j=$(( $j+1 ))
    echo -n +
    done
    echo \ Finished theta $theta
  done
  i=$(( $i+1 ))
done

echo

f="csma3_6"
echo $f
i="5"
while [ $i -lt $ntests ]
do
  for theta in "${thetas36[@]}"
  do
    echo $theta
    j="0"
    while [ $j -lt $nruns ]
    do
      ./rungc.sh $f.nm $f.fm 20 2000 30 -MACHINE -PROFILE -theta=$theta -BayesLearning -maxtraces=40000 >> csma_tests/$f\_HT_$theta\_test$i.txt
      j=$(( $j+1 ))
    echo -n +
    done
    echo \ Finished theta $theta
  done
  i=$(( $i+1 ))
done

echo


f="csma4_4"
echo $f
i="5"
while [ $i -lt $ntests ]
do
  for theta in "${thetas44[@]}"
  do
    echo $theta
    j="0"
    while [ $j -lt $nruns ]
    do
      ./rungc.sh $f.nm $f.fm 20 2000 30 -MACHINE -PROFILE -theta=$theta -BayesLearning -maxtraces=40000 >> csma_tests/$f\_HT_$theta\_test$i.txt
      j=$(( $j+1 ))
    echo -n +
    done
    echo \ Finished theta $theta
  done
  i=$(( $i+1 ))
done

echo


f="csma4_6"
echo $f
i="5"
while [ $i -lt $ntests ]
do
  for theta in "${thetas46[@]}"
  do
    echo $theta
    j="0"
    while [ $j -lt $nruns ]
    do
      ./rungc.sh $f.nm $f.fm 20 2000 30 -MACHINE -PROFILE -theta=$theta -BayesLearning -maxtraces=40000 >> csma_tests/$f\_HT_$theta\_test$i.txt
      j=$(( $j+1 ))
    echo -n +
    done
    echo \ Finished theta $theta
  done
  i=$(( $i+1 ))
done

echo

