/*
 *  rt_vectors.h - contains 2- and 3-vector classes
 *
 *
 *  Created by Sriram Vaidhyanathan on Thu Feb 26 2004.
 *  15-462 Computer Graphics Spring 2004 Programming Assignment 3
 *
 */

#ifndef _RT_VECTORS_H_
#define _RT_VECTORS_H_

#include <iostream>
using namespace std;

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>

/* Class for 2-vector */
class Vec2f
{

public:

    /* Data members */
    float data[2];


    /* Constructor */
    Vec2f() { data[0] = data[1] = 0; }

    /* Constructor */
    Vec2f(const Vec2f &V) {
        data[0] = V.data[0];
        data[1] = V.data[1];
    }

    /* Constructor */
    Vec2f(float d0, float d1) {
        data[0] = d0;
        data[1] = d1;
    }

    /* Constructor */
    Vec2f(const Vec2f &V1, const Vec2f &V2) {
        data[0] = V1.data[0] - V2.data[0];
        data[1] = V1.data[1] - V2.data[1];
    }

    /* Destructor */
    ~Vec2f() { }

    /* Access data members */
    void Get(float &d0, float &d1) const {
        d0 = data[0];
        d1 = data[1];
    }

    /* Operator overload */
    float operator[](int i) const {
        assert (i >= 0 && i < 2);
        return data[i];
    }

    /* Grab data members */
    float x() const { return data[0]; }
    float y() const { return data[1]; }

    /* figure out the length of the vector */
    float Length() const {
        float l = (float)sqrt( data[0] * data[0] + data[1] * data[1] );
        return l;
    }

    /* Set data members */
    void Set(float d0, float d1) {
        data[0] = d0;
        data[1] = d1;
    }

    /* Scale the vector */
    void Scale(float d0, float d1) {
        data[0] *= d0;
        data[1] *= d1;
    }

    /* Divide the vector */
    void Divide(float d0, float d1) {
        data[0] /= d0;
        data[1] /= d1;
    }

    /* Flip signs */
    void Negate() {
        data[0] = -data[0];
        data[1] = -data[1];
    }

    /* Operator overload */
    Vec2f& operator=(const Vec2f &V) {
        data[0] = V.data[0];
        data[1] = V.data[1];
        return *this;
    }

    /* Operator overload */
    int operator==(const Vec2f &V) const {
        return ((data[0] == V.data[0]) &&
                (data[1] == V.data[1]));
    }

    /* Operator overload */
    int operator!=(const Vec2f &V) {
        return ((data[0] != V.data[0]) ||
                (data[1] != V.data[1]));
    }

    /* Operator overload */
    Vec2f& operator+=(const Vec2f &V) {
        data[0] += V.data[0];
        data[1] += V.data[1];
        return *this;
    }

    /* Operator overload */
    Vec2f& operator-=(const Vec2f &V) {
        data[0] -= V.data[0];
        data[1] -= V.data[1];
        return *this;
    }

    /* Operator overload */
    Vec2f& operator*=(float f) {
        data[0] *= f;
        data[1] *= f;
        return *this;
    }

    /* Operator overload */
    Vec2f& operator/=(float f) {
        data[0] /= f;
        data[1] /= f;
        return *this;
    }

    /* Compute dot product */
    float Dot2(const Vec2f &V) const {
        return data[0] * V.data[0] + data[1] * V.data[1] ;
    }

    /* Add vectors */
    static void Add(Vec2f &a, const Vec2f &b, const Vec2f &c ) {
        a.data[0] = b.data[0] + c.data[0];
        a.data[1] = b.data[1] + c.data[1];
    }

    /* Subtract vectors */
    static void Sub(Vec2f &a, const Vec2f &b, const Vec2f &c ) {
        a.data[0] = b.data[0] - c.data[0];
        a.data[1] = b.data[1] - c.data[1];
    }

    /* Copy and scale vectors */
    static void CopyScale(Vec2f &a, const Vec2f &b, float c ) {
        a.data[0] = b.data[0] * c;
        a.data[1] = b.data[1] * c;
    }

    /* Add and scale vectors */
    static void AddScale(Vec2f &a, const Vec2f &b, const Vec2f &c, float d ) {
        a.data[0] = b.data[0] + c.data[0] * d;
        a.data[1] = b.data[1] + c.data[1] * d;
    }

    /* Average out vectors */
    static void Average(Vec2f &a, const Vec2f &b, const Vec2f &c ) {
        a.data[0] = (b.data[0] + c.data[0]) * 0.5f;
        a.data[1] = (b.data[1] + c.data[1]) * 0.5f;
    }

    /* Take weighted sum for vectors */
    static void WeightedSum(Vec2f &a, const Vec2f &b, float c, const Vec2f &d, float e ) {
        a.data[0] = b.data[0] * c + d.data[0] * e;
        a.data[1] = b.data[1] * c + d.data[1] * e;
    }

    /* Write out to stdout */
    void Write(FILE *F = stdout) {
        fprintf (F, "%f %f\n",data[0],data[1]);
    }
};

/* Class for 3-vectors */
class Vec3f
{
    
public:

    /* Data members */
    float data[3];


    /* Constructor */
    Vec3f() { data[0] = data[1] = data[2] = 0; }

    /* Constructor */
    Vec3f(const Vec3f &V) {
        data[0] = V.data[0];
        data[1] = V.data[1];
        data[2] = V.data[2]; }

    /* Constructor */
    Vec3f(float d0, float d1, float d2) {
        data[0] = d0;
        data[1] = d1;
        data[2] = d2; }

    /* Constructor */
    Vec3f(const Vec3f &V1, const Vec3f &V2) {
        data[0] = V1.data[0] - V2.data[0];
        data[1] = V1.data[1] - V2.data[1];
        data[2] = V1.data[2] - V2.data[2]; }

    /* Destructor */
    ~Vec3f() { }

    /* Access data members */
    void Get(float &d0, float &d1, float &d2) const {
        d0 = data[0];
        d1 = data[1];
        d2 = data[2];
    }

    /* Operator overload */
    float operator[](int i) const {
        assert (i >= 0 && i < 3);
        return data[i];
    }

    /* Grab data members */
    float x() const { return data[0]; }
    float y() const { return data[1]; }
    float z() const { return data[2]; }
    float r() const { return data[0]; }
    float g() const { return data[1]; }
    float b() const { return data[2]; }

    /* Compute length of vector */
    float Length() const {
        float l = (float)sqrt( data[0] * data[0] +
                               data[1] * data[1] +
                               data[2] * data[2] );
        return l;
    }

    /* Set vectors */
    void Set(float d0, float d1, float d2) {
        data[0] = d0;
        data[1] = d1;
        data[2] = d2;
    }

    /* Scale vector */
    void Scale(float d0, float d1, float d2) {
        data[0] *= d0;
        data[1] *= d1;
        data[2] *= d2;
    }

    /* Divide vector */
    void Divide(float d0, float d1, float d2) {
        data[0] /= d0;
        data[1] /= d1;
        data[2] /= d2;
    }

    /* Normalize vector */
    void Normalize() {
        float l = Length();
        if (l > 0) {
            data[0] /= l;
            data[1] /= l;
            data[2] /= l;
        }
    }

    /* Negate vector */
    void Negate() {
        data[0] = -data[0];
        data[1] = -data[1];
        data[2] = -data[2];
    }

    /* Operator overload */
    Vec3f& operator=(const Vec3f &V) {
        data[0] = V.data[0];
        data[1] = V.data[1];
        data[2] = V.data[2];
        return *this;
    }

    /* Operator overload */
    int operator==(const Vec3f &V) {
        return ((data[0] == V.data[0]) &&
                (data[1] == V.data[1]) &&
                (data[2] == V.data[2]));
    }

    /* Operator overload */
    int operator!=(const Vec3f &V) {
        return ((data[0] != V.data[0]) ||
                (data[1] != V.data[1]) ||
                (data[2] != V.data[2]));
    }

    /* Operator overload */
    Vec3f& operator+=(const Vec3f &V) {
        data[0] += V.data[0];
        data[1] += V.data[1];
        data[2] += V.data[2];
        return *this;
    }

    /* Operator overload */
    Vec3f& operator-=(const Vec3f &V) {
        data[0] -= V.data[0];
        data[1] -= V.data[1];
        data[2] -= V.data[2];
        return *this;
    }

    /* Operator overload */
    Vec3f& operator*=(int i) {
        data[0] = float(data[0] * i);
        data[1] = float(data[1] * i);
        data[2] = float(data[2] * i);
        return *this;
    }

    /* Operator overload */
    Vec3f& operator*=(float f) {
        data[0] *= f;
        data[1] *= f;
        data[2] *= f;
        return *this;
    }

    /* Operator overload */
    Vec3f& operator/=(int i) {
        data[0] = float(data[0] / i);
        data[1] = float(data[1] / i);
        data[2] = float(data[2] / i);
        return *this;
    }

    /* Operator overload */
    Vec3f& operator/=(float f) {
        data[0] /= f;
        data[1] /= f;
        data[2] /= f;
        return *this;
    }

    /* Operator overload */
    friend Vec3f operator+(const Vec3f &v1, const Vec3f &v2) {
        Vec3f v3; Add(v3,v1,v2); return v3;
    }

    /* Operator overload */
    friend Vec3f operator-(const Vec3f &v1, const Vec3f &v2) {
        Vec3f v3; Sub(v3,v1,v2); return v3;
    }

    /* Operator overload */
    friend Vec3f operator*(const Vec3f &v1, float f) {
        Vec3f v2; CopyScale(v2,v1,f); return v2;
    }

    /* Compute dot product */
    float Dot3(const Vec3f &V) const {
        return data[0] * V.data[0] +
        data[1] * V.data[1] +
        data[2] * V.data[2] ;
    }

    /* Add vectors */
    friend void Add(Vec3f &a, const Vec3f &b, const Vec3f &c ) {
        a.data[0] = b.data[0] + c.data[0];
        a.data[1] = b.data[1] + c.data[1];
        a.data[2] = b.data[2] + c.data[2];
    }

    /* Subtract vectors */
    friend void Sub(Vec3f &a, const Vec3f &b, const Vec3f &c ) {
        a.data[0] = b.data[0] - c.data[0];
        a.data[1] = b.data[1] - c.data[1];
        a.data[2] = b.data[2] - c.data[2];
    }

    /* Copy and scale vectors */
    friend void CopyScale(Vec3f &a, const Vec3f &b, float c ) {
        a.data[0] = b.data[0] * c;
        a.data[1] = b.data[1] * c;
        a.data[2] = b.data[2] * c;
    }

    /* Add and scale vectors */
    friend void AddScale(Vec3f &a, const Vec3f &b, const Vec3f &c, float d ) {
        a.data[0] = b.data[0] + c.data[0] * d;
        a.data[1] = b.data[1] + c.data[1] * d;
        a.data[2] = b.data[2] + c.data[2] * d;
    }

    /* Average out vectors */
    friend void Average(Vec3f &a, const Vec3f &b, const Vec3f &c ) {
        a.data[0] = (b.data[0] + c.data[0]) * 0.5f;
        a.data[1] = (b.data[1] + c.data[1]) * 0.5f;
        a.data[2] = (b.data[2] + c.data[2]) * 0.5f;
    }

    /* Take weighted sum of vectors */
    friend void WeightedSum(Vec3f &a, const Vec3f &b, float c, const Vec3f &d, float e ) {
        a.data[0] = b.data[0] * c + d.data[0] * e;
        a.data[1] = b.data[1] * c + d.data[1] * e;
        a.data[2] = b.data[2] * c + d.data[2] * e;
    }

    /* Compute cross product for vectors */
    static void Cross3(Vec3f &c, const Vec3f &v1, const Vec3f &v2) {
        float x = v1.data[1]*v2.data[2] - v1.data[2]*v2.data[1];
        float y = v1.data[2]*v2.data[0] - v1.data[0]*v2.data[2];
        float z = v1.data[0]*v2.data[1] - v1.data[1]*v2.data[0];
        c.data[0] = x; c.data[1] = y; c.data[2] = z;
    }

    /* Write out to stdout */
    void Write(FILE *F = stdout) {
        fprintf (F, "%f %f %f\n",data[0],data[1],data[2]);
    }
};

/* Operator overload - helpful to print out vectors */
inline ostream &operator<<(ostream &os, const Vec3f &v) {
    os << "Vec3f <" <<v.x()<<", "<<v.y()<<", "<<v.z()<<">";
    return os;
}

typedef Vec3f Color3;

#endif
