/** @file rt_trimesh.h
 *
 *   @brief Describes a triangle mesh in the scene
 *
 *   The parser constructs rt_TriMesh objects as they are read in from
 *   the SDL file. The triangle mesh must be defined in a wavefront-obj file.
 *   Add the necessary code and methods to interface this class with your
 *   ray tracer.
 *
 *  @author Initial design: Miklos Bergou (mbergou)
 **/

#ifndef __RT_TRIMESH__
#define __RT_TRIMESH__

#include "rt_object.h"
#include "rt_vectors.h"
#include "rt_parse.h"

#include <vector>

class rt_TriMesh : public rt_Object
{
 public:
  /** @brief Constructor for group objects
   *
   *  The triangl mesh is read in from the provided obj file.
   *
   *  @param parser Pointer to the parser instantiating the object
   *  @param objfile File containing the triangle mesh
   *  @param mesh_mat Index of material to use for triangle mesh
   **/
  rt_TriMesh(rt_parse *parser, const char * objfile, int mesh_mat);
 private:
  void parse (char * line, int max, char * command, int & position);
  Vec3f* getVec (char * str);
  void getCoords(char *str, int &num, int v_index[3], int n_index[3]);
  vector<rt_Triangle*> triangles;
};


#endif /* __RT_TRIMESH__ */

