/** @file rt_triangle.h
 *
 *   @brief Describes a triangle in the scene
 *
 *   The parser constructs rt_Triangle objects as they are read in from
 *   the SDL file. Add the necessary code and methods to interface this class
 *   with your ray tracer.
 *
 *  @author Initial design: Mark T. Tomczak (mtomczak)
 **/

#ifndef __RT_TRIANGLE__
#define __RT_TRIANGLE__

#include "rt_object.h"
#include "rt_vectors.h"
#include "rt_parse.h"

class rt_Triangle : public rt_Object{
public:
  /** @brief Constructor for group objects
   *
   *  You should initialize the triangle from the parameters provided:
   *
   *  @param parser Pointer to the parser instantiating the object
   *  @param p0 First vertex of triangle
   *  @param p1 Second vertex of triangle
   *  @param p2 Third vertex of triangle
   *  @param n0 First vertex normal
   *  @param n1 Second vertex normal
   *  @param n2 Third vertex normal
   *  @param m0 Index of material at first vertex
   *  @param m1 Index of material at second vertex
   *  @param m2 Index of material at third vertex
   *  @param ts0 S coordinate of texture at vertex 0
   *  @param tt0 T coordinate of texture at vertex 0
   *  @param ts1 S coordinate of texture at vertex 1
   *  @param tt1 T coordinate of texture at vertex 1
   *  @param ts2 S coordinate of texture at vertex 2
   *  @param tt2 T coordinate of texture at vertex 2
   **/
  rt_Triangle(rt_parse *parser, Vec3f p0, Vec3f p1, Vec3f p2,
              Vec3f n0, Vec3f n1, Vec3f n2,
                      int m0, int m1, int m2,
                      float ts0, float tt0,
                      float ts1, float tt1,
                      float ts2, float tt2);
};


#endif /* __RT_TRIANGLE__ */

