/** @file rt_sphere.h
 *
 *   @brief A sphere in the scene
 *
 *  Add the necessary code and methods to interface this class with 
 *  your ray tracer.
 *
 *  @author Initial design: Mark T. Tomczak (mtomczak)
 **/

#ifndef __RT_SPHERE__
#define __RT_SPHERE__

#include "rt_vectors.h"
#include "rt_object.h"
#include "rt_parse.h"

class rt_Sphere : public rt_Object{
public:
  /** @brief Constructor for sphere objects
   *
   *  @param parser Pointer to parser constructing the object
   *  @param c Coordinates for center of sphere
   *  @param r Radius of sphere
   *  @param mi Material index of sphere
   **/
  rt_Sphere(rt_parse *parser, Vec3f c, float r, int mi);
};

#endif /* __RT_SPHERE__ */

