/** @file rt_object.h
 *
 *   @brief generic scene object
 *
 *   The rt_Object class serves as a common base class for triangles and
 *   spheres (and other objects). Most methods defined here should be declared
 *   virtual, so that child classes may override them. Add the necessary code 
 *   and methods to interface this class with your ray tracer.
 *
 *  @author Initial design: Mark T. Tomczak (mtomczak)
 **/

#ifndef __RT_OBJECT__
#define __RT_OBJECT__


#include "rt_parse.h"

class rt_Object{
public:
  /** @brief Constructor for rt_Object
   *
   *  @param parser Pointer to parser instantiating the object
   */
  rt_Object(rt_parse *parser);
};

#endif /* __RT_OBJECT__ */

