function [ind] = sample_rows(A, s, probs);
%
% [ind] = sample_rows(probs, s, probs)
% 
% This function samples s rows from a matrix A with respect to 
% the probabilities in the vector probs. 
%
% By Jimeng Sun, 08/31/07
% Copyright 2007, Jimeng SUN

prob_rows = cumsum(probs);
% Pick a random subset of s rows of A

% pick random numbers between 0 and 1
rand_rows = rand(s,1);

for i=1:s,
    %
    % Find the first element in rand_cols that is larger than
    % the random number and pick the appropriate column. Update
    % the matrix C and the vector COLS_PICKED.
    %
    tempI = find(prob_rows > rand_rows(i));
    temp_ind(i) = tempI(1);
end
ind = temp_ind;
