function X = pinvs(A, k)
%PINVS   Pseudoinverse.
%   X = PINVS(A) produces a matrix X of the same dimensions
%   as A' so that A*X*A = A, X*A*X = X and A*X and X*A
%   are Hermitian.
%
%   A: input matrix
%   k: the rank of A
%
% By Jimeng Sun, 08/31/07
% Copyright 2007, Jimeng SUN

[U,S,V] = svds(A,k);
s = diag(S);
k = length(s);
S = diag(ones(k,1)./s);
X = V*S*U';