function [C, U, R, rerr, cid, rid, ccnt, rcnt] = CMD(A, k, c, r);
% [C, U, R, rerr, cid, rid, ccnt, rcnt] = CMDstar(A, k, c, r);
% CMDstar     Constructs the CMD decomposition (no duplicates)
%
% Input:
%   A: original data matrix
%   k: the rank of the low rank approximation
%   c, r: the number of column and row samples (before duplicate removal)
% Output:
%   C,U,R: the decomposed matrices, s.t. norm(A-C*U*R,'fro') is small
%   rerr: relative reconstruction error in Frobenius norm
%   cid, rid: sample col/row ids from A in C and R
%   ccnt, rcnt: the number of copies of each sample col and row
%
% Examples:
% >> A = rand(100,10)*rand(10,10)*rand(10,50);
% >> rank(A)
% 
% ans =
% 
%     10    
% >> [C, U, R, rerr, cid, rid, ccnt, rcnt] = CMD(A, 10, 20, 15);    
% >> rerr
% rerr =
%    1.4329e-26
%
% By Jimeng Sun, 08/31/07
% Copyright 2007, Jimeng SUN


if nargin < 4
    c = k;
    r = k;
end
%proportional to row/column length
[prow, pcol] = fast_sample_prob(A);
[rids] = sample_rows(A, r, prow);
[cids] = sample_rows(A', c, pcol);
%count the duplicates 
% very very tricky and crazy, understanding is not required
[tmp, rid, rcnt] = find(sparse(1,rids,1));
[tmp, cid, ccnt] = find(sparse(1,cids,1));

C = A(:,cid)*diag(ccnt.^(1/2));
Cinv = pinvs(C,k);
R = diag(rcnt.^(1/2))*A(rid,:);
Rinv = pinvs(R,k);
U = Cinv*A*Rinv;

if nargout>3
    rerr = norm(A-C*U*R,'fro')^2/norm(A,'fro')^2;
end