// TormTimer.cpp: implementation of the TormTimer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TormTimer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void TormTimer::schedule(double delay){
	m_nstimer=NsInterface::schedule_timer(this,delay);
	return ;
}
void TormTimer::reschedule(double delay){
	if (m_nstimer==0) schedule(delay);
	else {
		cancel();
		schedule(delay);
	}
}
void TormTimer::cancel(){
	if (m_nstimer==0) return;
	NsInterface::cancel_timer(m_nstimer);
	m_nstimer=0;
}
void TormTimer::expire(){
	m_app->OnTimer();
	m_nstimer=0;
	return ;
}
