// TormInterface.cpp: implementation of the TormInterface class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TormInterface.h"
#include "TormTimer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void TormInterface::DeleteApp(void * app){
	TRACE("Deleting app...\n");
	delete (TormApp *)app;
}

void TormInterface::OnReceive(void * app,void * buf, int size){
		TormApp * ta = (TormApp *)app;
		ta->OnReceive(buf,size);
}
void TormInterface::OnTimer(void * handler){
	((TormTimer *)handler)->expire();
}
void * TormInterface::NewApp(void * agent,int argc,const char*const* argv){
		TRACE("trace into New App, argc=%d\n",argc);
		if (argc==2) {
			if (strcmp(argv[0],"BroadcastTime")==0) {
				if (strcmp(argv[1],"SERVER")==0)
					return (new BroadcastTime(agent,AT_SERVER));
				else return (new BroadcastTime(agent,AT_CLIENT));
			} 
		}
		return NULL;
};
int TormInterface::DispatchCMD ( void * app,int argc , const char*const* argv)
{
	TormApp * ta =(TormApp *)app;
	return ta->DispatchCMD(argc,argv);
}
