// TormApp.h: interface for the TormApp class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TORMAPP_H__B4B23396_F6B4_11D3_B58F_00C04F4A10E3__INCLUDED_)
#define AFX_TORMAPP_H__B4B23396_F6B4_11D3_B58F_00C04F4A10E3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "NsInterface.h"

class TormApp  
{
	friend class TormTimer;
public:
	TormApp(void *agent){m_agent=agent;};
	virtual ~TormApp();
	virtual void OnReceive(void *buf,int size)=0;
	void SendData(void * buf,int size){
		NsInterface::send(m_agent,buf,size);
	}
	void JoinGroup(char * grpname){
		NsInterface::join_group(m_agent,grpname);
	}
	void LeaveGroup(char * grpname){
		NsInterface::leave_group(m_agent,grpname);
	}
	virtual int DispatchCMD(int argc,const char*const* argv)=0;
	virtual void OnTimer();
protected:
	void * m_agent;
};

#endif // !defined(AFX_TORMAPP_H__B4B23396_F6B4_11D3_B58F_00C04F4A10E3__INCLUDED_)
