// BroadcastTime.h: interface for the BroadcastTime class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BROADCASTTIME_H__B4B2338C_F6B4_11D3_B58F_00C04F4A10E3__INCLUDED_)
#define AFX_BROADCASTTIME_H__B4B2338C_F6B4_11D3_B58F_00C04F4A10E3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TormApp.h"
#include "TormTimer.h"

typedef enum { PT_REQ,PT_DATA} PTYPE;
typedef enum { AT_SERVER,AT_CLIENT } ATYPE;

class Packet {
public :
	Packet(PTYPE type){m_type=type;m_len=0;};
	static Packet* newpkt(PTYPE type,char * buf,int len) {
		Packet * pkt;
		pkt =(Packet *) malloc(sizeof(Packet)+len);
		pkt->m_type=type;
		pkt->m_len=len;
		memcpy( ((char*)pkt)+sizeof(Packet),buf,len);
		return pkt;
	}
	~Packet(){};

	PTYPE m_type;
	int m_len;
};


class BroadcastTime  :public TormApp
{
public:
	BroadcastTime(void * agent,ATYPE type=AT_CLIENT);
	virtual ~BroadcastTime();
public:
	void bcasttime();
	void request();
	virtual void OnReceive(void * buf, int size);
	virtual int DispatchCMD(int argc,const char*const* argv);
	virtual void OnTimer();
protected:
	ATYPE m_type;
	TormTimer m_timer;
};

#endif // !defined(AFX_BROADCASTTIME_H__B4B2338C_F6B4_11D3_B58F_00C04F4A10E3__INCLUDED_)
