// BroadcastTime.cpp: implementation of the BroadcastTime class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "BroadcastTime.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BroadcastTime::BroadcastTime(void * agent,ATYPE type):TormApp(agent),m_timer(this)
{
	m_type = type;
	if (m_type==AT_CLIENT) 
		  m_timer.schedule(0.3);
	else m_timer.schedule(0.1);
}

BroadcastTime::~BroadcastTime()
{
}
void BroadcastTime::OnTimer() {
	TRACE("Received Timer message.\n");
	if (m_type==AT_SERVER) {
		bcasttime();
		m_timer.schedule(0.1);
	} else {
		request();
		m_timer.schedule(0.1);
	}
}
void BroadcastTime::bcasttime()
{
	long tm ;
	time(&tm);
	TRACE("broadcasting ...\n");
	Packet * pkt = Packet::newpkt(PT_DATA,(char *)&tm,sizeof(long));
	SendData((void *)pkt,sizeof(Packet)+sizeof(long));
	free((void *)pkt);
}

void BroadcastTime::request()
{
	Packet pkt(PT_REQ);
	TRACE("sending reqeust...\n");
	SendData((void *)&pkt,sizeof(Packet));
}

int BroadcastTime::DispatchCMD(int argc,const char*const* argv){
	if (argc==1) {
		if (strcmp(argv[0],"Broadcast")==0){
			bcasttime();
			return 1;
		}else if (strcmp(argv[0],"Request")==0){
			request();
			return 1;
		}
	} else if (argc==2){
		if (strcmp(argv[0],"join-group")==0){
			JoinGroup((char *)argv[1]);
			return 1;
		}
		if (strcmp(argv[0],"leave-group")==0){
			LeaveGroup((char *)argv[1]);
			return 1;
		}
	}
	return 0;
}
void BroadcastTime::OnReceive(void * buf, int size)
{
	Packet * pkt;
	TRACE("Received message\n");
	pkt = (Packet *)buf;
	ASSERT(pkt->m_len==(int)(size-sizeof(Packet)));

	if (pkt->m_type==PT_DATA){
		long * tm = (long *)(((char *)pkt)+sizeof(Packet));
		TRACE("Received broadcast time :%s",ctime(tm));
	} else {
		ASSERT(pkt->m_type==PT_REQ);
		if (m_type==AT_SERVER){
			bcasttime();			
		}
	}

}
