<!-- #include file="jons_strings.asp" --><!-- String parsing algorithms -->

<%
Dim debugGcalendarParse
debugGcalendarParse = false

' Declare our vectors of events
Dim vTitle(), vDateBegin(), vDateEnd(), vWhere(), vDesc() 'Parallel arrays for storing event data
Dim nVecSize 'Number of elements in the vectors
nVecSize = 0

Function GetGcalendarEventCount()
	GetGcalendarEventCount = nVecSize
End Function

Function GetGcalendarEventTitle( eventNum )
	GetGcalendarEventTitle = vTitle( eventNum )
End Function

Function GetGcalendarEventDateBegin( eventNum )
	GetGcalendarEventDateBegin = vDateBegin( eventNum )
End Function

Function GetGcalendarEventDateEnd( eventNum )
	GetGcalendarEventDateEnd = vDateEnd( eventNum )
End Function

Function GetGcalendarEventWhere( eventNum )
	GetGcalendarEventWhere = vWhere( eventNum )
End Function

Function GetGcalendarEventDesc( eventNum )
	GetGcalendarEventDesc = vDesc( eventNum )
End Function

Function ParseGcalendar( myPublicGoogleCalendarXmlUrl )	
	Dim nInitSize
	nInitSize = 256 'Initial size of vectors
	'TODO: Deal with more than 256 events at a time
	Redim vTitle(nInitSize)
	Redim vDateBegin(nInitSize)
	Redim vDateEnd(nInitSize)
	Redim vWhere(nInitSize)
	Redim vDesc(nInitSize)
	nVecSize = 0
	
	Dim xmlDom, nodeCol, oNode, oChildNode
	Set xmlDom = Server.CreateObject("MSXML2.Domdocument.4.0")
	
	Call xmlDom.setProperty("ServerHTTPRequest", true)
	xmlDom.async = false
	Call xmlDom.load(myPublicGoogleCalendarXmlUrl)
	
	If xmlDom.parseError.errorCode <> 0 Then
		Response.Write("Parse error while trying to read XML Google Calendar")
	End If
	
	If debugGcalendarParse Then Response.Write("Begin XML parsing dump: <br>")
	If Not xmlDom.documentElement Is Nothing Then
		
		'Iterate through all first level children
		Dim outerLst,i
		Set outerLst = xmlDom.getElementsByTagName("*")
		For i = 0 to (outerLst.length-1)
			If outerLst.item(i).nodeName = "entry" Then
			
				'Iterate through all second level children
				Dim innerLst,j
				Set innerLst = outerLst.item(i).getElementsByTagName("*")
				For j = 0 to (innerLst.length-1)
				
					Dim tok, title, when, where, stat, desc
					If innerLst.item(j).nodeName = "title" Then
						title = innerLst.item(j).text
						vTitle(nVecSize) = title
					ElseIf innerLst.item(j).nodeName = "content" Then
						Dim content
						content = innerLst.item(j).text
	
						'Extract each atom (piece) from the string
						If InStr(content, "When: ") Then
							tok = ExtractAfterString(content, "When: ")
							when = ExtractBeforeString(tok, "<br><br>")
							
							'Get individual pieces of date, then remove each piece of date to get the next piece
							Dim strDateStart, dateStart, dateEnd
							strDateStart = ExtractBeforeString(when, " ")
							dateStart = CDate(strDateStart)
							dateEnd = CDate(strDateStart)
							
							vDateBegin(nVecSize) = dateStart 'Insert at back of vector
							vDateEnd(nVecSize) = dateEnd
							
							'UH BOY: Getting the starting time and the ending date/time
							'will actually be somewhat complicated due to the variable format Google usess
						End If
						If InStr(content, "Where: ") Then
							tok = ExtractAfterString(content, "Where: ")
							where = ExtractBeforeString(tok, "<br>")
							vWhere(nVecSize) = where 'Insert at back of vector
						End If
						'stat = ExtractBetweenStrings(content, "Event Status: ", "<br>")
						If InStr(content, "Event Description:") Then
							desc = ExtractAfterString(content, "Event Description:")
							If desc = "null" Then
								desc = ""
							End If
							vDesc(nVecSize) = desc 'Insert at back of vector
							'NOTE: This is always the last piece of the string
						End If
	
						'TODO: Deconstruct "when" into year, month, day, start time, and end time
						'TODO: Link to google map of place
						
						If debugGcalendarParse Then
							Response.Write("Title is: <b>" & title & "</b><br>")
							Response.Write("Dates are: " & when & "<br>")
							Response.Write("Place is: " & where & "<br>")
							Response.Write("Description: " & desc & "<br>")
						End If
						
						nVecSize = nVecSize+1
						
						' Grow our vector if needed
						If nVecSize >= nInitSize Then
							nInitSize = nInitSize * 2
							Redim vTitle(nInitSize)
							Redim vDateBegin(nInitSize)
							Redim vDateEnd(nInitSize)
							Redim vWhere(nInitSize)
							Redim vDesc(nInitSize)
						End If ' End grow vector
					End If 'End entry found
				Next
			End If
		Next 'End iterate through all outer nodes
	End If 'End XML document valid
	
	
	'Time to Sort!
	Dim tempTitle, tempDateBegin, tempDateEnd, tempWhere, tempDesc
	'Dim i, j 
	For i = 0 To nVecSize - 1
		For j = i To nVecSize - 1
			'Sort Ascending
			If vDateBegin(i) > vDateBegin(j) Then
				'Begin the massive triangular trading
				tempTitle = vTitle(i)
				vTitle(i) = vTitle(j)
				vTitle(j) = tempTitle
				
				tempDateBegin = vDateBegin(i)
				vDateBegin(i) = vDateBegin(j)
				vDateBegin(j) = tempDateBegin
				
				tempDateEnd = vDateEnd(i)
				vDateEnd(i) = vDateEnd(j)
				vDateEnd(j) = tempDateEnd
				
				tempWhere = vWhere(i)
				vWhere(i) = vWhere(j)
				vWhere(j) = tempWhere
				
				tempDesc = vDesc(i)
				vDesc(i) = vDesc(j)
				vDesc(j) = tempDesc
			End if 'i > j
		Next 'j
	Next 'i
	
End Function

'TODO: Move all this garbage to separate files
%>