<%

' Format and write the data from the GCalendar to Response.Write
Function FormatGcalendar()

	' Feel free to edit these first few variables to customize the look
	Dim strMonthTitleFormat			
	strMonthTitleFormat = "<p align = ""center"" class = ""MonthYear"">"
	Dim strMonthTitleFormatClose	
	strMonthTitleFormatClose = "<br>"
	Dim strMonthHeader				
	strMonthHeader = "<table width = ""80%"" border = ""2"" cellpadding = ""5"" cellspacing = ""2"">"
	Dim strMonthFooter				
	strMonthFooter = "</table><p>&nbsp</p>"
	
	Dim strLineHeader				
	strLineHeader = "<tr>"
	Dim strLineFooter				
	strLineFooter = "</tr>"
	
	Dim strDateHeader				
	strDateHeader = "<td bgcolor = ""#FFFFCC"" align = ""center""><span class = ""Date"">"
	Dim strDateFooter				
	strDateFooter = "</span>"
	Dim strDayHeader				
	strDayHeader = "<br><span class = ""Day"">"
	Dim strDayFooter				
	strDayFooter = "</span></td>"
	
	Dim strTitleHeader				
	strTitleHeader = "<td bgcolor = ""#FFFFCC""><span class = ""EventTitle"">"
	Dim strTitleFooter				
	strTitleFooter = "</span>"
	
	Dim strDescHeader				
	strDescHeader = "<br><span class = ""Description"">"
	Dim strWherePrefix				
	strWherePrefix = "<br><br><b>Where:</b> "
	Dim strDescFooter				
	strDescFooter = "</span></td>"
	
	' If you edit anything below this line, I'd recommend just rewriting this whole function for yourself
	Dim boolHasEvents
	Dim nEventNum
	nEventNum = 0
	Do Until nEventNum = GetGcalendarEventCount() 'Iterate through all the events we just read in
		boolHasEvents = false ' This variable is true if we write any events
		Dim currentMonth 
		currentMonth = Month( GetGcalendarEventDateBegin(nEventNum) )
		Do While Month( GetGcalendarEventDateBegin(nEventNum) ) = currentMonth ' Loop for calendar table for a single month
			currentMonth = Month( GetGcalendarEventDateBegin(nEventNum) )
				
				' Only write a header if we're writing events for this month and this is the first event
				If Not boolHasEvents Then
					boolHasEvents = true
					Response.Write( strMonthTitleFormat )
					Response.Write( MonthName( DatePart("m", GetGcalendarEventDateBegin(nEventNum) ) ) )
					Response.Write( " " )
					Response.Write( DatePart( "yyyy", GetGcalendarEventDateBegin(nEventNum) ) )
					Response.Write( strMonthTitleFormatClose )
					Response.Write( strMonthHeader )
				End If ' !boolHasEvents
				Response.Write( strLineHeader )
				
				' Write Date
				Response.Write( strDateHeader )
				Response.Write( DatePart( "d", GetGcalendarEventDateBegin(nEventNum) ) )
				Response.Write( strDateFooter )
				Response.Write( strDayHeader )
				Response.Write( WeekDayName( DatePart( "w", GetGcalendarEventDateBegin(nEventNum) ) ) )
				Response.Write( strDayFooter )
		
				' Write Title
				Response.Write( strTitleHeader )
				Response.Write( GetGcalendarEventTitle(nEventNum) )
				Response.Write( strTitleFooter )
				
				' Write description below title
				Response.Write( strDescHeader )
				Response.Write( GetGcalendarEventDesc(nEventNum) )

				Response.Write( strWherePrefix )
				' Replace http:// and www. addresses with "Map" links				
				Response.Write( FormatMapLink(GetGcalendarEventWhere(nEventNum)) )
				Response.Write( strDescFooter )
				
				Response.Write( strLineFooter )
				nEventNum = nEventNum + 1 'Increment event num to continue iteration
				If nEventNum = GetGcalendarEventCount() Then
					Exit Do
				End If
			Loop ' end month while
			If boolHasEvents Then
				Response.Write( strMonthFooter )
			Else
				nEventNum = nEventNum + 1 'Increment event num to continue iteration
			End If ' boolHasEvents
		Loop 'End of this event
	' Make sure we write SOMETHING
	If not boolHasEvents Then
		%> No events <%
	End If
End Function ' FormatGcalendar()

' Find a token in this substring that begins with http or www.
' and create a link called "Map" out of it
Function FormatMapLink( str )
	Dim address
	Dim link
	If InStr("http:", str) >= 0 Then
		address = ExtractTokenStartingWith( str, "http:" )
		link = "<a href =""" + address + """><b>Map</b></a>"		
		str = Replace( str, address, link, 1, 1)
	ElseIf InStr("www.", str) >= 0 Then
		address = ExtractTokenStartingWith( str, "www." )
		link = "<a href =""http://" + address + """><b>Map</b></a>"
		str =  Replace( str, address, link, 1, 1)
	End If
	FormatMapLink = str
End Function
%>